/*
 * Decompiled with CFR 0.152.
 */
package com.orcinus.world.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.orcinus.config.ConfigHolder;
import com.orcinus.world.carver.AbstractCarver;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class ExperimentalCavernCarver
extends AbstractCarver<ProbabilityConfig> {
    private long seed;
    private long worldSeed;
    private double amplitude;
    private OctavesNoiseGenerator caveNoise;
    private OctavesNoiseGenerator offsetNoise;
    private OctavesNoiseGenerator scaleNoise;
    private SharedSeedRandom random;

    public ExperimentalCavernCarver(Codec<ProbabilityConfig> codec, int maxHeight, boolean aquifers) {
        super(codec, maxHeight, aquifers);
        this.field_222718_j = ImmutableSet.of((Object)Blocks.field_150355_j);
        this.field_222719_k = ImmutableSet.of((Object)Fluids.field_204546_a, (Object)Fluids.field_207212_b);
        this.random = new SharedSeedRandom(this.seed);
        this.caveNoise = new OctavesNoiseGenerator(this.random, IntStream.rangeClosed(-15, 0));
        this.offsetNoise = new OctavesNoiseGenerator(this.random, IntStream.rangeClosed(-15, 0));
        this.scaleNoise = new OctavesNoiseGenerator(this.random, IntStream.rangeClosed(-12, 0));
    }

    protected boolean func_227208_a_(IChunk chunk, Function<BlockPos, Biome> biomePos, long seed, int seaLevel, int chunkX, int chunkZ, double randOffsetXCoord, double startY, double randOffsetZCoord, double p_227208_14_, double p_227208_16_, BitSet carvingMask) {
        this.worldSeed = seed;
        return super.func_227208_a_(chunk, biomePos, this.worldSeed, seaLevel, chunkX, chunkZ, randOffsetXCoord, startY, randOffsetZCoord, p_227208_14_, p_227208_16_, carvingMask);
    }

    @Override
    public boolean func_225555_a_(IChunk chunk, Function<BlockPos, Biome> biomePos, Random rand, int seaLevel, int chunkXOffset, int chunkZOffset, int chunkX, int chunkZ, BitSet carvingMask, ProbabilityConfig config) {
        if (chunkX != chunkXOffset || chunkZ != chunkZOffset) {
            return false;
        }
        int chunkStartX = chunk.func_76632_l().func_180334_c();
        int chunkStartZ = chunk.func_76632_l().func_180333_d();
        double[][][] noiseTerrain = new double[2][5][8];
        for (int noiseZ = 0; noiseZ < 5; ++noiseZ) {
            noiseTerrain[0][noiseZ] = new double[11];
            this.sampColumn(noiseTerrain[0][noiseZ], chunkX * 4, chunkZ * 4 + noiseZ, this.caveNoise, this.offsetNoise, this.scaleNoise);
            noiseTerrain[1][noiseZ] = new double[11];
        }
        for (int noiseX = 0; noiseX < 4; ++noiseX) {
            int noiseZ;
            for (noiseZ = 0; noiseZ < 5; ++noiseZ) {
                this.sampColumn(noiseTerrain[1][noiseZ], chunkX * 4 + noiseX + 1, chunkZ * 4 + noiseZ, this.caveNoise, this.offsetNoise, this.scaleNoise);
            }
            for (noiseZ = 0; noiseZ < 4; ++noiseZ) {
                for (int noiseY = 8; noiseY >= 0; --noiseY) {
                    double x0y0z0 = noiseTerrain[0][noiseZ][noiseY];
                    double x0y0z1 = noiseTerrain[0][noiseZ + 1][noiseY];
                    double x1y0z0 = noiseTerrain[1][noiseZ][noiseY];
                    double x1y0z1 = noiseTerrain[1][noiseZ + 1][noiseY];
                    double x0y1z0 = noiseTerrain[0][noiseZ][noiseY + 1];
                    double x0y1z1 = noiseTerrain[0][noiseZ + 1][noiseY + 1];
                    double x1y1z0 = noiseTerrain[1][noiseZ][noiseY + 1];
                    double x1y1z1 = noiseTerrain[1][noiseZ + 1][noiseY + 1];
                    for (int primeY = 8; primeY >= 0; --primeY) {
                        int realY = noiseY * 9 + primeY;
                        double deltaY = (double)primeY / 9.0;
                        double x0z0 = MathHelper.func_219803_d((double)deltaY, (double)x0y0z0, (double)x0y1z0);
                        double x1z0 = MathHelper.func_219803_d((double)deltaY, (double)x1y0z0, (double)x1y1z0);
                        double x0z1 = MathHelper.func_219803_d((double)deltaY, (double)x0y0z1, (double)x0y1z1);
                        double x1z1 = MathHelper.func_219803_d((double)deltaY, (double)x1y0z1, (double)x1y1z1);
                        for (int primeX = 0; primeX < 4; ++primeX) {
                            int realX = chunkStartX + noiseX * 4 + primeX;
                            int localX = realX & 0xF;
                            double deltaX = (double)primeX * 0.25;
                            double gradientZ0 = MathHelper.func_219803_d((double)deltaX, (double)x0z0, (double)x1z0);
                            double gradientZ1 = MathHelper.func_219803_d((double)deltaX, (double)x0z1, (double)x1z1);
                            for (int primeZ = 0; primeZ < 4; ++primeZ) {
                                int realZ = chunkStartZ + noiseZ * 4 + primeZ;
                                int localZ = realZ & 0xF;
                                double deltaZ = (double)primeZ * 0.25;
                                double noises = MathHelper.func_219803_d((double)deltaZ, (double)gradientZ0, (double)gradientZ1);
                                if (!(noises < 0.0)) continue;
                                BlockPos realPos = new BlockPos(chunkX * 16 + localX, realY, chunkZ * 16 + localZ);
                                this.carveBlock(chunk, biomePos, chunkX, chunkZ, localX, localZ, rand, realY);
                            }
                        }
                    }
                }
            }
            double[][] ds = noiseTerrain[0];
            noiseTerrain[0] = noiseTerrain[1];
            noiseTerrain[1] = ds;
        }
        return true;
    }

    private void carveBlock(IChunk chunk, Function<BlockPos, Biome> biomePos, int chunkX, int chunkZ, int localX, int localZ, Random random, int y) {
        int i;
        int x = chunkX * 16 + localX;
        int z = chunkZ * 16 + localZ;
        BlockPos blockPos = new BlockPos(x, y, z);
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        BlockState state = field_222715_g.getBlockState();
        Biome biome = biomePos.apply((BlockPos)pos);
        Biome noiseBiome = chunk.func_225549_i_().func_225526_b_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (!this.func_222707_a(chunk.func_180495_p(blockPos), chunk.func_180495_p(blockPos.func_177984_a()))) {
            return;
        }
        if (y > 50) {
            for (i = 0; i < 9; ++i) {
                if (chunk.func_180495_p(pos.func_177981_b(i)) == Blocks.field_150350_a.func_176223_P()) {
                    return;
                }
                if (chunk.func_180495_p(pos.func_177981_b(i)).func_185904_a() != Material.field_151586_h) continue;
                return;
            }
        }
        if (chunk.func_180495_p(blockPos.func_177984_a()).func_185904_a() == Material.field_151586_h) {
            state = Blocks.field_201941_jj.func_176223_P();
            if (y > 25) {
                return;
            }
            if (y < 11) {
                return;
            }
        }
        if (chunk.func_180495_p(pos.func_177984_a()) == Blocks.field_150351_n.func_176223_P()) {
            for (i = 0; i < 4; ++i) {
                chunk.func_177436_a(pos.func_177981_b(i), Blocks.field_196656_g.func_176223_P(), false);
            }
        }
        if (chunk.func_180495_p(pos.func_177984_a()).func_203425_a(Blocks.field_150354_m)) {
            for (i = 0; i < 4; ++i) {
                chunk.func_177436_a(pos.func_177981_b(i), Blocks.field_150322_A.func_176223_P(), false);
            }
        }
        if (chunk.func_180495_p(pos.func_177984_a()) == Blocks.field_196611_F.func_176223_P()) {
            for (i = 0; i < 4; ++i) {
                chunk.func_177436_a(pos.func_177981_b(i), Blocks.field_180395_cM.func_176223_P(), false);
            }
        } else {
            int locX = x & 0xF;
            int locZ = z & 0xF;
            if (chunk.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h || y < this.field_222720_l && chunk.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h || locX < 15 && chunk.func_180495_p(blockPos.func_177974_f()).func_185904_a() == Material.field_151586_h || locX > 0 && chunk.func_180495_p(blockPos.func_177976_e()).func_185904_a() == Material.field_151586_h || locZ > 0 && chunk.func_180495_p(blockPos.func_177978_c()).func_185904_a() == Material.field_151586_h || locZ < 15 && chunk.func_180495_p(blockPos.func_177968_d()).func_185904_a() == Material.field_151586_h) {
                return;
            }
            if (y < 11) {
                state = Blocks.field_150353_l.func_176223_P();
            }
            if (y < 5) {
                return;
            }
            chunk.func_177436_a(blockPos, state, false);
            chunk.func_212247_j().func_205360_a((BlockPos)pos, (Object)Fluids.field_204547_b, 0);
            chunk.func_212247_j().func_205360_a((BlockPos)pos, (Object)Fluids.field_204546_a, 0);
        }
    }

    private void sampColumn(double[] buffer, int x, int z, OctavesNoiseGenerator caveNoise, OctavesNoiseGenerator offsetNoise, OctavesNoiseGenerator scaleNoise) {
        for (int y = 0; y < buffer.length; ++y) {
            double offset = offsetNoise.func_205563_a((double)x, (double)y, (double)z);
            SharedSeedRandom random = new SharedSeedRandom();
            random.func_202422_a(x, z);
            if (random.nextInt(13) == 0) {
                offset += (double)(4 * random.nextInt(4));
            }
            buffer[y] = this.sampleNoise(caveNoise, scaleNoise, x, y, z) + this.cutOff(offset, y);
        }
    }

    private double sampleNoise(OctavesNoiseGenerator caveNoise, OctavesNoiseGenerator scaleNoise, int x, int y, int z) {
        double noise = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < 6; ++i) {
            ImprovedNoiseGenerator sampler = caveNoise.func_215463_a(i);
            noise += sampler.func_215456_a((double)x * (Double)ConfigHolder.xzCavernCompression.get() * amplitude, (double)y * (Double)ConfigHolder.yCavernCompression.get() * amplitude, (double)z * (Double)ConfigHolder.xzCavernCompression.get() * amplitude, 0.0, 0.0) / amplitude;
            amplitude *= 0.5;
        }
        return noise *= 1.2;
    }

    protected boolean func_222707_a(BlockState state, BlockState aboveState) {
        return state != Blocks.field_196658_i.func_176223_P() || state != Blocks.field_150346_d.func_176223_P() || super.func_222707_a(state, aboveState);
    }

    private double cutOff(double offset, int y) {
        double scale = 10.65 + offset;
        double cutOff = (double)y + scale / (double)y * 2.0;
        cutOff += MathHelper.func_151238_b((double)0.75, (double)cutOff, (double)offset);
        return cutOff += 2.5;
    }

    @Override
    public boolean func_212868_a_(Random rand, int chunkX, int chunkZ, ProbabilityConfig config) {
        return true;
    }

    @Override
    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return false;
    }
}

